/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.vm.app.services.impl;

import com.opencsv.CSVWriter;
import eu.europa.ec.taxud.cesop.vm.app.services.impl.CsvExporter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class CsvExporter {
    private static final String VALIDATION_OUTPUT_FILENAME = "validation_output.csv";
    private static final char QUOTE_CHAR = '\u0000';
    private static final char ESCAPE_CHAR = '\u0000';
    private static final char SEPARATOR = ',';
    private static final String END_LINE = "\n";

    public static Path export(List<ValidationResultCsvDTO> dtos, Path path) throws IOException {
        Path csvPath = path.resolve(VALIDATION_OUTPUT_FILENAME);
        if (csvPath.toFile().exists()) {
            Files.delete(csvPath);
        }
        Files.createFile(csvPath, new FileAttribute[0]);
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath.toString()), ',', '\u0000', '\u0000', END_LINE);){
            writer.writeNext(new String[]{"File Path", "File Size", "MessageRefId", "Validation Result"});
            if (CollectionUtils.isNotEmpty(dtos)) {
                dtos.forEach(dto -> writer.writeNext(dto.toStringLine()));
            }
        }
        return csvPath;
    }
}

